% function Linear_KD_WT_model()

% This is the main function of the linear KD and linear WT models


close all

view_angle = [83, 68];

%%%% Model parameters %%%%

n_steps = 100;                             % number of points to calculate, (n_steps) x (n_steps)
index = 0 : (n_steps - 1);
v_actin_step = log(3000) / (n_steps - 1);
v_actin = 0.1 * exp(index * v_actin_step); % [nm/s], retrograde actin flow

a_1 = 26; %26; %0.75;   % [nm], characteristic radius of single clutch adhesion site
a_2 = 1700;             % [nm], characteristic size of cell adhesion complexes, = 550 nm [Artola, Nature Materials, 2014], = 1700 nm [Artola, Nat Cell Biol, 2016]

myosin_unloaded_rate = 120;       % [nm/s], = 110 nm/s [Artola, Nature Materials, 2014], = 110 nm/s [Artola, Nat Cell Biol, 2016], ~200 nm/s [Beausang et al, Biophys. J., 2008, 95:5820]
myosin_stall_force = 2;           % [pN], = 2 pN [Artola, Nature Materials, 2014], = 2 pN [Artola, Nat Cell Biol, 2016]
myosin_density = 71; %71; %85;    % Myosin density, [1/um^2]. Based on Alieva and Hu papers.

clutches_density = 300; %300;            % [1/um^2], density of sites available for molecular clutch formation (clutches max density = integrin density)
clutches_stiffness = 1.6; %1.6; %0.05;   % [pN/nm], clutches spring constant, = 1 nN/nm [Artola, Nature Materials, 2014]

k_on = 0.0051; %0.0051; %0.23;   % [1/s], formation rate of molecular clutches
l_yield = 150; %150; %1000;      % [nm], l_y value of the nonlinear behaviour of molecular clutches

Young_modulus_max = 1e+10;
Young_modulus_min = 1e+02;
substrate_stiffness_max = Young_modulus_max * ( 4 * pi / 9 * a_1 * 10^(-9) * 1000 );      % [Pa]
substrate_stiffness_min = Young_modulus_min * ( 4 * pi / 9 * a_1 * 10^(-9) * 1000 );      % [Pa]
substrate_stiffness_step = log(Young_modulus_max / Young_modulus_min) / (n_steps - 1);
substrate_stiffness = substrate_stiffness_min * exp(index * substrate_stiffness_step)';   % [pN/nm]

% [Artola 2016] data
k_off_1 = 0.3755; %0.3755;         % [1/s], dissociation rate of molecular clutches (catch bond)
k_off_2 = 5.433e-05; %5.433e-05;   % [1/s], dissociation rate of molecular clutches (catch bond)
dissociation_force_1 = -38.09;     % [pN], characteristic dissociation force (catch bond)
dissociation_force_2 = 4.411;      % [pN], characteristic dissociation force (catch bond)

% [Kong 2009] data
% k_off_1 = 5.463;   
% k_off_2 = 0.1381;  
% dissociation_force_1 = -10.98;  
% dissociation_force_2 = 20.58;  

myosin_number   = pi * a_2^2 / 1e+06 * myosin_density;    % total number of myosin II motors
clutches_number = pi * a_2^2 / 1e+06 * clutches_density;  % total number of sites available for molecular clutch formation

effective_stiffness = substrate_stiffness * clutches_stiffness ./ (substrate_stiffness + clutches_stiffness);

Young_modulus = substrate_stiffness / ( 4 * pi / 9 * a_1 * 10^(-9) * 1000 ); % [Pa]

myosin_force = myosin_stall_force * myosin_number * (1 - v_actin / myosin_unloaded_rate); % force-velocity curve of myosin II
myosin_force(myosin_force < -1000) = -1000;

s1 = length(substrate_stiffness);
myosin_force = repmat(myosin_force, s1, 1);
Cell_traction_myosin = myosin_force * 1e-12 / pi / (a_2 * 1e-09)^2; % [Pa]

%%%%%%% Experimental data from [Artola, Nat Cell Biol, 2016] %%%%%%%

figure(100)

data_x = [620
2400
4700
11000
15000
30000];

data_y_1 = [20
54.8
83
47
33
37];

data_y_2 = [
22.4
53.2
92
89
88
137];

data_y_3 = [21.1
51.4
39.8
34.8
30.1
36.8];

data_y_4 = [20.5
47.7
81.1
116.6
60.7
37.7];

semilogx(data_x, data_y_1, 'bo')
hold on
semilogx(data_x, data_y_2, 'ro')
% hold on
% semilogx(data_x, data_y_3, 'go')
% semilogx(data_x, data_y_4, 'co')
title('Cell traction')
xlabel('Young modulus, Pa') 
ylabel('Cell traction, Pa')
axis([Young_modulus_min Young_modulus_max 0 350])

figure(101)

data_x = [2400
4400
11000
15000
30000];

data_y_1 = [71
45
68
84
98];

data_y_2 = [76
48
56
54
25];

    Young_flow = [260
    730
    1090
    1280
    24000
    57000];

    Flow = [77.6419
    75.8952
    84.9782
    101.9214
    110.4803
    105.2402];

semilogx(data_x, data_y_1, 'bo')
hold on
semilogx(data_x, data_y_2, 'ro')
% hold on
% semilogx(Young_flow, Flow, 'go')
title('Actin flow rate')
xlabel('Young modulus, Pa') 
ylabel('Actin flow rate, nm/s')
axis([Young_modulus_min Young_modulus_max 0 140])

%%%%%%%% Linear clutch, catch bond, full model %%%%%%%%

break_flag = false;

force_catch_full_model = zeros(n_steps, n_steps);

for i = 1 : n_steps
    disp(['k_substrate = ' num2str(substrate_stiffness(i)) ' pN/nm'])
    k_stiffness = effective_stiffness(i);
    clutches_k_off_integral = @(x) k_off_integral_catch_bond_v4c(x, l_yield, k_stiffness, k_off_1, k_off_2, dissociation_force_1, dissociation_force_2);
    force = @(x) force_with_yield_point(x, l_yield, k_stiffness);
        
    parfor j = 1 : n_steps
        v = v_actin(j);

        warning('off', 'MATLAB:integral:NonFiniteValue')
            
        %%% C_coeff calculation %%%

        integrand_fun_1 = @(x) exp(-clutches_k_off_integral(x) / v);
        C_coeff_catch_full_model = k_on / (k_on * integral( integrand_fun_1, 0, Inf ) + v);
            
        %%% Average force calculation %%%

        p_on = @(x) C_coeff_catch_full_model * exp(-clutches_k_off_integral(x) / v);
        integrand_fun_2 = @(x) force(x) .* p_on(x);
        force_catch_full_model(i, j) = clutches_number * integral( integrand_fun_2, 0, Inf );
            
        warning('on','all')
    end
end

Cell_traction_substrate = force_catch_full_model * 1e-12 / pi / (a_2 * 1e-09)^2; % [Pa]

figure(22)
    
surf(log10(v_actin), log10(Young_modulus), force_catch_full_model)
colormap jet
shading interp
freezeColors()
hold on
surf(log10(v_actin), log10(Young_modulus), myosin_force, 'FaceColor', [0.7 0.7 0.7], 'EdgeColor', 'none');
% view(view_angle)
view(58, 57)
axis([log10(v_actin(1)) log10(v_actin(end)) 2 6 0 1.3 * max(force_catch_full_model, [], 'all')])
% axis([log10(v_actin(1)) log10(v_actin(end)) 2 6 0 1000])
 
figure(5) 
    
M = contour(log10(v_actin), log10(Young_modulus), force_catch_full_model-myosin_force, [0 0], 'k');
        
N_max = length(M);
s = 1;
while s <= N_max
    x_zero_contour = M(1, (s + 1) : ( s + M(2,s) ) );
    y_zero_contour = M(2, (s + 1) : ( s + M(2,s) ) );
    s = s + M(2,s) + 1;
        
    Young_modulus_temp = 10.^y_zero_contour;
        
    velocity_zero_contour = 10.^x_zero_contour;
    
    z_zero_contour = (1 - velocity_zero_contour / myosin_unloaded_rate) * myosin_stall_force * myosin_number;
    z_zero_contour(z_zero_contour < 0) = 0;
    
    Young_modulus_force_catch_bond_model_zero_contour = Young_modulus_temp;
    force_catch_bond_model_zero_contour = z_zero_contour;

    index_new = 1;
    index_old = 1;
    flag = 1;
    figure(22)
    for j = 2 : length(Young_modulus_temp) - 1
        if( Young_modulus_temp(j) < Young_modulus_temp(j-1) && Young_modulus_temp(j) < Young_modulus_temp(j+1))
            index_new = j;
            plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k', 'LineWidth', 2)
            plot3(x_zero_contour(index_new), y_zero_contour(index_new), z_zero_contour(index_new), 'wo', 'MarkerFaceColor','white', 'MarkerEdgeColor', 'black', 'MarkerSize', 5)
            index_old = index_new;
            flag = 0;
        end
        if( Young_modulus_temp(j) > Young_modulus_temp(j-1) && Young_modulus_temp(j) > Young_modulus_temp(j+1))
            index_new = j;
            plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'w', 'LineWidth', 2)
            plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k--', 'LineWidth', 2)
            plot3(x_zero_contour(index_new), y_zero_contour(index_new), z_zero_contour(index_new), 'wo', 'MarkerFaceColor','white', 'MarkerEdgeColor', 'black', 'MarkerSize', 5)
            index_old = index_new;
            flag = 1;
        end
    end
        
    index_new = length(Young_modulus_temp);
    if(flag == 1)
        plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k', 'LineWidth', 2)
    else
        plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'w', 'LineWidth', 2)
        plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k--', 'LineWidth', 2)
    end
        
    title('Velocity-stiffness-force, catch bond model')
    xlabel('Lg movement rate, nm/s') 
    ylabel('Lg(E)') 
    zlabel('Force, pN') 
%   view(view_angle)
    view(58, 57)
        
    if(break_flag)
        break
    end
end
    
    
figure(24)
   
surf(log10(v_actin), log10(Young_modulus), Cell_traction_substrate)
colormap jet
shading interp
freezeColors()
hold on
surf(log10(v_actin), log10(Young_modulus), Cell_traction_myosin, 'FaceColor', [0.7 0.7 0.7], 'EdgeColor', 'none');
% axis([log10(v_actin(1)) log10(v_actin(end)) log10(Young_modulus(1))  log10(Young_modulus(end)) 0 1.1 * max(Cell_traction_substrate, [], 'all')])
axis([log10(v_actin(1)) log10(v_actin(end)) log10(Young_modulus(1)) log10(Young_modulus(end)) 0 1.3 * max(Cell_traction_substrate, [], 'all')])
% axis([log10(v_actin(1)) log10(200) 2  6 0 400])
% colormap gray
% shading interp

title('Velcotiy-stiffness-force, full catch model')
xlabel('Lg movement rate, nm/s') 
ylabel('Lg(E), Pa') 
zlabel('Cell traction, Pa') 
view(view_angle)

figure(5)

surf(log10(v_actin), log10(Young_modulus), Cell_traction_substrate-Cell_traction_myosin)
colormap jet
shading interp
hold on
    
M = contour(log10(v_actin), log10(Young_modulus), Cell_traction_substrate-Cell_traction_myosin, [0 0], 'k');
    
N_max = length(M);
s = 1;
while s <= N_max
    x_zero_contour = M(1, (s + 1) : ( s + M(2,s) ) );
    y_zero_contour = M(2, (s + 1) : ( s + M(2,s) ) );
    s = s + M(2,s) + 1;
        
    Young_modulus_temp = 10.^y_zero_contour;
               
    velocity_zero_contour = 10.^x_zero_contour;
            
    force_zero_contour = (1 - velocity_zero_contour / myosin_unloaded_rate) * myosin_stall_force * myosin_number;
       
    z_zero_contour = force_zero_contour * 1e-12 / pi / (a_2 * 1e-09)^2; % [Pa]
    z_zero_contour(z_zero_contour < 0) = 0;
    
    index_new = 1;
    index_old = 1;
    flag = 1;
        
    figure(24)
    for j = 2 : length(Young_modulus_temp) - 1
        if( Young_modulus_temp(j) < Young_modulus_temp(j-1) && Young_modulus_temp(j) < Young_modulus_temp(j+1))
            index_new = j;
            plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k', 'LineWidth', 2)
            plot3(x_zero_contour(index_new), y_zero_contour(index_new), z_zero_contour(index_new), 'wo', 'MarkerFaceColor','white', 'MarkerEdgeColor', 'black', 'MarkerSize', 5)
            index_old = index_new;
            flag = 0;
        end
        if( Young_modulus_temp(j) > Young_modulus_temp(j-1) && Young_modulus_temp(j) > Young_modulus_temp(j+1))
            index_new = j;
            plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'w', 'LineWidth', 2)
            plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k--', 'LineWidth', 2)
            plot3(x_zero_contour(index_new), y_zero_contour(index_new), z_zero_contour(index_new), 'wo', 'MarkerFaceColor','white', 'MarkerEdgeColor', 'black', 'MarkerSize', 5)
            index_old = index_new;
            flag = 1;
        end
    end
        
    index_new = length(Young_modulus_temp);
    if(flag == 1)
        plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k', 'LineWidth', 2)
    else
        plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'w', 'LineWidth', 2)
        plot3(x_zero_contour(index_old : index_new), y_zero_contour(index_old : index_new), z_zero_contour(index_old : index_new), 'k--', 'LineWidth', 2)
    end
        
    title('Velocity-stiffness-traction, catch bond model')
    xlabel('Lg movement rate, nm/s') 
    ylabel('Lg(E)') 
    zlabel('Cell traction, Pa') 
    view(view_angle)
               
    Actin_flow_zero_contour_catch_full_model = 10.^x_zero_contour;
    Young_modulus_zero_contour_catch_full_model = 10.^y_zero_contour;
    Cell_traction_zero_contour_catch_full_model = z_zero_contour;
       
    figure(6)
%   hold on
    substrate_stiffness_catch_full_model = ( 4 * pi / 9 * a_1 * 10^(-9) * 1000 ) * Young_modulus_zero_contour_catch_full_model;
    effective_stiffness_catch_full_model = substrate_stiffness_catch_full_model * clutches_stiffness ./ (substrate_stiffness_catch_full_model + clutches_stiffness);
      
    F_average_catch_full_model = Young_modulus_zero_contour_catch_full_model;
    p_on_catch_full_model = Young_modulus_zero_contour_catch_full_model;
        
    parfor j = 1 : length(Young_modulus_zero_contour_catch_full_model)
        warning('off', 'MATLAB:integral:NonFiniteValue')
            
        k_stiffness = effective_stiffness_catch_full_model(j);
        v = Actin_flow_zero_contour_catch_full_model(j);
        clutches_k_off_integral = @(x) k_off_integral_catch_bond_v4c(x, l_yield, k_stiffness, k_off_1, k_off_2, dissociation_force_1, dissociation_force_2);
        force = @(x) force_with_yield_point(x, l_yield, k_stiffness);
                     
        %%% C_coeff calculation %%%
            
        integrand_fun_3 = @(x) exp(-clutches_k_off_integral(x) / v);
        C_coeff_catch_full_model = k_on / (k_on * integral( integrand_fun_3, 0, Inf ) + v);

        %%% Average force calculation %%%

        p_on = @(x) C_coeff_catch_full_model * exp( -clutches_k_off_integral(x) / v );
        integrand_fun_4 = @(x) force(x) .* p_on(x);
        p_on_catch_full_model(j) = integral( p_on, 0, Inf );
        F_average_catch_full_model(j) = integral( integrand_fun_4, 0, Inf ) / p_on_catch_full_model(j);

        warning('on','all')
    end
        
    semilogx(Young_modulus_zero_contour_catch_full_model, F_average_catch_full_model, 'b--')
    hold on
    title('Tension of a single clutch')
    xlabel('Young modulus, Pa') 
    ylabel('Average force, pN') 
        
    figure(7)
    Loading_rate_average_zero_contour = effective_stiffness_catch_full_model .* Actin_flow_zero_contour_catch_full_model;
    semilogx(Young_modulus_zero_contour_catch_full_model, Loading_rate_average_zero_contour, 'b--')
    hold on
    title('Average loading rate of a single clutch')
    xlabel('Young modulus, Pa') 
    ylabel('Average loading rate, pN/s') 
        
    figure(8)
%   hold on
    Clutches_on_number = clutches_number * p_on_catch_full_model;
    Clutches_on_density = Clutches_on_number / (pi * a_2^2) * 1e+06;
    semilogx(Young_modulus_zero_contour_catch_full_model, Clutches_on_number, 'b--')
    hold on
    title('Average number of bonds')
    xlabel('Young modulus, Pa') 
    ylabel('Average number of bonds') 
        
%   figure(9)
%   semilogx(Young_modulus_zero_contour_catch_full_model, clutches_number_catch_full_model * p_on_catch_full_model .* force_catch_full_model, 'g')
%   hold on
%   title('Total force')
%   xlabel('Young modulus, Pa') 
%   ylabel('Total force, pN') 
      
    figure(100)
    hold on
    semilogx(Young_modulus_zero_contour_catch_full_model, Cell_traction_zero_contour_catch_full_model, 'b--')

    figure(101)
    hold on
    semilogx(Young_modulus_zero_contour_catch_full_model, Actin_flow_zero_contour_catch_full_model, 'b--')
        
    if(break_flag)
        break
    end
end
    

boundary_1_E = -1;
boundary_2_E = -1;
boundary_1_v = -1;
boundary_2_v = -1;
    
for j = 2 : length(Young_modulus_zero_contour_catch_full_model) - 1
    if( Young_modulus_zero_contour_catch_full_model(j) < Young_modulus_zero_contour_catch_full_model(j-1) && Young_modulus_zero_contour_catch_full_model(j) < Young_modulus_zero_contour_catch_full_model(j+1))
        boundary_1_E = Young_modulus_zero_contour_catch_full_model(j);
        boundary_1_v = Actin_flow_zero_contour_catch_full_model(j);
    end
    if( Young_modulus_zero_contour_catch_full_model(j) > Young_modulus_zero_contour_catch_full_model(j-1) && Young_modulus_zero_contour_catch_full_model(j) > Young_modulus_zero_contour_catch_full_model(j+1))
        boundary_2_E = Young_modulus_zero_contour_catch_full_model(j);
        boundary_2_v = Actin_flow_zero_contour_catch_full_model(j);
    end
end





